#ifndef	__DirectDraw_Calls_H__
#define	__DirectDraw_Calls_H__

#include "DirectX Common.h"
#include <ddraw.h>

// Direct Draw Functions

#ifdef __cplusplus
extern "C" {
#endif

// Surface Functions

void DDCreateSurface ( LPDIRECTDRAW7 pExistingDirectDraw,
			DDSURFACEDESC2 *pNewSurfaceDesc, LPDIRECTDRAWSURFACE7 *ppNewSurface );
void DDCreateSurfaceInMemory ( LPDIRECTDRAW7 pExistingDirectDraw,
								DDSURFACEDESC2 *pNewSurfaceDesc,
								BOOLEAN fVideoMemory, LPDIRECTDRAWSURFACE7 *ppNewSurface );
void DDCreateZBufferSurface ( LPDIRECTDRAW7 pDirectDraw, INT32 iWidth, INT32 iHeight,
									  BOOLEAN fVideoMemory, LPDIRECTDRAWSURFACE7 *ppZBufferSurface );
void DDCreateRasterSurface ( LPDIRECTDRAW7 pDirectDraw, INT32 iWidth, INT32 iHeight,
									  BOOLEAN fVideoMemory, LPDIRECTDRAWSURFACE7 *ppRasterSurface );
void DDGetSurfaceDescription ( LPDIRECTDRAWSURFACE7 pSurface, DDSURFACEDESC2 *pSurfaceDesc );
void DDGetSurfaceCaps ( LPDIRECTDRAWSURFACE7 pSurface, DDSCAPS2 *pSurfaceCaps );
void DDAddAttachedSurface ( LPDIRECTDRAWSURFACE7 pParentSurface,
							LPDIRECTDRAWSURFACE7 pAddChildSurface );
void DDDeleteAttachedSurface ( LPDIRECTDRAWSURFACE7 pParentSurface,
							LPDIRECTDRAWSURFACE7 pDeleteChildSurface );
void DDReleaseSurface (	LPDIRECTDRAWSURFACE7 *ppOldSurface );

void DDGetDDInterface( LPDIRECTDRAWSURFACE7 pSurface, LPDIRECTDRAW7 *ppDirectDraw );


void DDLockSurface( LPDIRECTDRAWSURFACE7 pSurface, LPRECT pDestRect, LPDDSURFACEDESC2 pSurfaceDesc,
					    UINT32 uiFlags, HANDLE hEvent);

void DDUnlockSurface( LPDIRECTDRAWSURFACE7 pSurface, PTR pSurfaceData );

void DDRestoreSurface( LPDIRECTDRAWSURFACE7 pSurface );

void DDBltFastSurface( LPDIRECTDRAWSURFACE7 pDestSurface, UINT32 uiX, UINT32 uiY, LPDIRECTDRAWSURFACE7 pSrcSurface, 
							LPRECT pSrcRect, UINT32 uiTrans);

void DDBltSurface( LPDIRECTDRAWSURFACE7 pDestSurface, LPRECT pDestRect, LPDIRECTDRAWSURFACE7 pSrcSurface,
					    LPRECT pSrcRect, UINT32 uiFlags, LPDDBLTFX pDDBltFx );

void DDSetSurfacePalette( LPDIRECTDRAWSURFACE7 pSurface, LPDIRECTDRAWPALETTE pDDPalette );

void DDGetSurfacePalette( LPDIRECTDRAWSURFACE7 pSurface, LPDIRECTDRAWPALETTE *ppDDPalette );

void DDGetDC( LPDIRECTDRAWSURFACE7 pSurface, HDC *phDC );

void DDReleaseDC( LPDIRECTDRAWSURFACE7 pSurface, HDC hDC );

void DDSetSurfaceColorKey( LPDIRECTDRAWSURFACE7 pSurface, UINT32 uiFlags, LPDDCOLORKEY pDDColorKey );


// Palette Functions

void DDCreatePalette( LPDIRECTDRAW7 pDirectDraw, UINT32 uiFlags, LPPALETTEENTRY pColorTable, LPDIRECTDRAWPALETTE FAR *ppDDPalette,
								IUnknown FAR * pUnkOuter);


void DDSetPaletteEntries( LPDIRECTDRAWPALETTE pPalette, UINT32 uiFlags, UINT32 uiStartingEntry,
								UINT32 uiCount, LPPALETTEENTRY pEntries );

void DDReleasePalette( LPDIRECTDRAWPALETTE pPalette );


void DDGetPaletteEntries( LPDIRECTDRAWPALETTE pPalette, UINT32 uiFlags, UINT32 uiBase,
								UINT32 uiNumEntries, LPPALETTEENTRY pEntries );


// Clipper functions
void DDCreateClipper( LPDIRECTDRAW7 pDirectDraw, UINT32 fFlags, LPDIRECTDRAWCLIPPER *pDDClipper );
void DDSetClipper( LPDIRECTDRAWSURFACE7 pSurface, LPDIRECTDRAWCLIPPER pDDClipper );
void DDReleaseClipper( LPDIRECTDRAWCLIPPER pDDClipper );
void DDSetClipperList( LPDIRECTDRAWCLIPPER pDDClipper, LPRGNDATA pClipList, UINT32 uiFlags);

HRESULT BltFastDDSurfaceUsingSoftware( LPDIRECTDRAWSURFACE7 pDestSurface, INT32 uiX, INT32 uiY, LPDIRECTDRAWSURFACE7 pSrcSurface, LPRECT pSrcRect, UINT32 uiTrans );
HRESULT BltDDSurfaceUsingSoftware( LPDIRECTDRAWSURFACE7 pDestSurface, LPRECT pDestRect, LPDIRECTDRAWSURFACE7 pSrcSurface, LPRECT pSrcRect, UINT32 uiFlags, LPDDBLTFX pDDBltFx );


#define IDirectDrawSurface7_SGPBltFast(p,a,b,c,d,e)         ( ( gfDontUseDDBlits == TRUE ) ?  BltFastDDSurfaceUsingSoftware( p, a, b, c, d, e ) : ( IDirectDrawSurface7_BltFast(p,a,b,c,d,e) ) )
#define IDirectDrawSurface7_SGPBlt(p,a,b,c,d,e)							( ( gfDontUseDDBlits == TRUE ) ?  BltDDSurfaceUsingSoftware( p, a, b, c, d, e ) : ( IDirectDrawSurface7_Blt(p,a,b,c,d,e) ) )


#ifdef __cplusplus
}
#endif


#endif	// __DirectDraw_Calls_H__